'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Binary       'Binary wichtig fr .LastModified !
Option Explicit

Private Sub Bild3_DblClick(Cancel As Integer)
    DoCmd.Close acForm, "Programmstart", acSaveNo
End Sub

Private Sub Form_Activate()
    Me.Repaint
End Sub

Private Sub Form_Load()
    On Error Resume Next    'Abbruch bei Fehlern vermeiden
    
    'Layout der Ribbons laden
    LoadRibbons
    

    Dim dbs As Database
    Dim tdf As TableDef
    Dim rst As Recordset
    
    Dim sDrive      As String
    Dim sPath       As String
    Dim sFilename   As String
    Dim sExtension  As String
    Dim sSourcePath As String
    
    Dim Quellpfad As String
    Dim i As Long
    Dim PfadErfragen As Boolean
    Dim DateiSuche As String
    
    'Hinweisfenster auffrischen
    Me.Repaint
    
    'Aktuelle Datenbank festlegen
    Set dbs = CurrentDb
    
    'Pfad fr die Quell-Datenbank berprfen
    '--------------------------------------------------------------------------
    
    'Pfad aus Tabelle holen
    Set rst = dbs.OpenRecordset("Datenbankpfad")
    If rst.RecordCount = 0 Then
        'in der Tabelle gibt es keinen Datensatz!
        rst.AddNew
        rst.Update
    End If
    rst.MoveFirst
    If IsNull(rst!Quelle) Or (Len(Trim(rst!Quelle)) < 1) Then
        Quellpfad = ""
    Else
        Quellpfad = Trim(rst!Quelle)
    End If
    
    rst.Close
    Set dbs = Nothing
    
    'Pfad in Bestandteile zerlegen
    sDrive = ""
    sPath = ""
    sFilename = ""
    sExtension = ""
    sSourcePath = Quellpfad
    Call SplitPath(sSourcePath, sDrive, sPath, sFilename, sExtension)
    '  MsgBox sDrive
    '  MsgBox sPath
    '  MsgBox sFilename
    '  MsgBox sExtension
    '  MsgBox sSourcePath
    'wenn Pfad ungltig oder Datei nicht gefunden, kompletten Dateipfad erfragen
    PfadErfragen = False
    
    'Datei-Typ
    If Fix(Val(SysCmd(acSysCmdAccessVer))) < 12 Then    'bei aktuellem Access bis 2003
        If Len(sExtension) <> 3 Then                    'Endung muss genau 3 Zeichen lang sein
            PfadErfragen = True
        Else
            If UCase(sExtension) <> "MDB" Then          'Endung muss genau "MDB" sein
                PfadErfragen = True
            End If
        End If
    End If
    If Fix(Val(SysCmd(acSysCmdAccessVer))) >= 12 Then   'bei aktuellem Access ab 2007
        If Len(sExtension) <> 5 Then                    'Endung muss genau 3 Zeichen lang sein
            PfadErfragen = True
        Else
            If UCase(sExtension) <> "ACCDB" Then        'Endung muss genau "ACCDB" sein
                PfadErfragen = True
            End If
        End If
    End If
    
    'Datei-Name
    If Len(sFilename) < 1 Then                      'Dateiname muss mindestens 1 Zeichen haben
        PfadErfragen = True
    Else
        If (UCase(sExtension) = "MDB") Or (UCase(sExtension) = "ACCDB") Then
            DateiSuche = ""
            DateiSuche = Dir(sSourcePath)
            If DateiSuche = "" Then                 'Datei auch vorhanden?
                PfadErfragen = True
            Else
            
            Set dbs = OpenDatabase(sSourcePath)
            Set rst = dbs.OpenRecordset("Einstellungen")
            
            'vorhandene Version mit erforderlicher Version prfen
            PfadErfragen = True
            If rst!DatenbankVersion = VersionDatenbank Then
                PfadErfragen = False
            End If
            
            rst.Close
            dbs.Close
            
            End If
        End If
    End If
    'wenn auch nur eine der Bedingungen nicht erfllt ist,...
    If PfadErfragen = True Then
    
        DoCmd.OpenForm "Datenbankpfad_eingeben"
        Forms![Datenbankpfad_eingeben]![GesuchterPfad].Caption = sSourcePath
        Forms![Datenbankpfad_eingeben].Repaint
        
        DoCmd.Close acForm, "Programmstart", acSaveNo
        DoCmd.Close acForm, "Hauptmenue", acSaveNo
        
        Exit Sub
        
    End If

    'Ribbon aktivieren
    DoCmd.Close acForm, "Hauptmenue", acSaveNo
    DoCmd.OpenForm "Hauptmenue"
    

End Sub

